//
//  ChargeDataModel.swift
//  PhoneManager
//
//  Created by edy on 2025/4/7.
//

import Foundation


struct ChargeDataModel {
    var isFree:Bool
    var coverImage:UIImage?
    var url : URL
    init(isFree: Bool, coverImage: UIImage, url: URL) {
        self.isFree = isFree
        self.coverImage = coverImage
        self.url = url
    }
    
    func toDictionary() -> [String: Any] {
        if let imageData = coverImage!.pngData() {
            print("成功将图片转换为 PNG 格式的 Data，数据大小: \(imageData.count) 字节")
            return [
                "isFree": isFree,
                "coverImage": imageData,
                "url": url.absoluteString
            ]
        } else {
            print("转换失败")
        }
        return [:]
    }
    init?(dictionary: [String: Any]) {
        guard let isFree = dictionary["isFree"] as? Bool,
              let coverImageData = dictionary["coverImage"] as? Data,
              let url = dictionary["url"] as? String else {
            return nil
        }
        self.isFree = isFree
        self.coverImage = UIImage(data: coverImageData)!
        self.url = URL(string: url)!
    }
}
