//
//  ChargeViewController.swift
//  PhoneManager
//
//  Created by edy on 2025/3/26.
//

import UIKit

class ChargeViewController:BaseViewController {
    
    lazy var detailsBtn:UIButton = {
        
        let sview:UIButton = UIButton()
        
        sview.setImage(UIImage(named: "ic_details_charging"), for: .normal)
        sview.width = 28
        sview.height = 28
        sview.x = view.width - sview.width - 15
        sview.centerY = navCenterY
        sview.addTarget(self, action: #selector(guideClick), for: .touchUpInside)
        
        return sview
    }()
    
    lazy var chargeView:ChargeView = {
        
        let cY:CGFloat = titleView.height + titleView.y
        
        let sview:ChargeView = ChargeView(frame: CGRect(x: 0, y: cY, width: view.width, height: view.height - cY))
        
        return sview
    }()
    
    override func viewDidLoad() {
        
        super.viewDidLoad()
        
        APIReportManager.shared.startReport(type: .Charging_show)
        
        titleView.addSubview(detailsBtn)
        
        view.addSubview(chargeView)
        
        self.chargeView.clickCallBack = {[weak self] model,row in
            guard let self else {return}
            let vc:ChargeInfoViewController = ChargeInfoViewController(model: model, type: ChargeInfoViewController.ChargeInfoType.setting)
            vc.flag = row
            self.navigationController?.pushViewController(vc, animated: true)
        }
    }
    
    override func viewDidAppear(_ animated: Bool) {
        
        super.viewDidAppear(animated)
        
        self.barHidden = false
    }
    
    // 跳转充电引导
    @objc func guideClick(){
        
        let vc : ChargeGuideStartController = ChargeGuideStartController()
        let navigation = UINavigationController(rootViewController: vc)
        navigation.modalPresentationStyle = .fullScreen
        self.present(navigation, animated: true)
        vc.callback = {[weak self] text in
            guard let self else {return}
//            let vc : ChargeGuideController = ChargeGuideController()
//            self.navigationController?.pushViewController(vc, animated: true)
        }
       
    }

}
