//
//  ADModel.swift
//  PhoneManager
//
//  Created by edy on 2025/5/26.
//

import Foundation

struct ADConfigModel:Codable{
    var showAd:Bool?
    var showReward:Bool?
    var showInter:Bool?
    var rewardID:String?
    var interID:String?
}

enum ADTypeEnum{
    case reward,inter
}


enum ADShowError{
    case limit
    case noAd
    case unkown
    case presentFail
    case fail(Error?)
    
    var localizedDescription: String {
        switch self {
        case .limit:
            return "ad is limit time"
        case .noAd:
            return "no ad to show"
        case .unkown:
            return "unkown error"
        case .fail(let error):
            return error?.localizedDescription ?? "fail"
        case .presentFail:
            return "can not present ad"
        }
        
    }
}


enum ADShowTypeEnum{
    case Merge,PhotoDelete,Secret,Email,Charge,Compress,videoDdelete,Trash,EmailLoginSignOut,Widgets
    
    var name:String{
        switch self {
        case .Merge:
            return "Merge"
        case .PhotoDelete:
            return "PhotoDelete"
        case .Secret:
            return "Secret"
        case .Email:
            return "Email"
        case .Charge:
            return "Charge"
        case .Compress:
            return "Compress"
        case .videoDdelete:
            return "videoDelete"
        case .Trash:
            return "Trash"
        case .EmailLoginSignOut:
            return "EmailLoginSignOut"
        case .Widgets:
            return "Widgets"
        }
    }
}
