//
//  BaseNavViewController.swift
//  PhoneManager
//
//  Created by zxhy on 2025/3/19.
//

import UIKit

class BaseNavViewController:UINavigationController ,UIGestureRecognizerDelegate {
    
    var barStatyl:UIStatusBarStyle = .darkContent {
        
        didSet {
            
            self.setNeedsStatusBarAppearanceUpdate()
        }
    }
    
    var barHidden:Bool = false {
        
        didSet {
            
            self.setNeedsStatusBarAppearanceUpdate()
        }
    }
    
    enum AnimationType {
        case def
        case recectToFull
        case overRightToLeft
        case overBottomToTop
        case dissRight
    }
    
    enum PushAnimationType {
        case normal
        case diy
        case bottomToTop
        case book
    }
    
    var isAnimation:AnimationType
    
    var cIsPopGestureRecognizer:Bool
    
    var cPushAnimation:PushAnimationType
    
    init(isAnimation:AnimationType = .def,rootViewController:UIViewController,isPopGestureRecognizer:Bool = true,pushAnimation:PushAnimationType = .normal) {
        
        self.isAnimation = isAnimation
        self.cIsPopGestureRecognizer = isPopGestureRecognizer
        self.cPushAnimation = pushAnimation
        super.init(rootViewController: rootViewController)
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        setupUI()
    }
    
    func setupUI()  {
        
        navigationBar.isHidden = true
        
        self.delegate = self
        
        interactivePopGestureRecognizer?.delegate = self
        
        if isAnimation != .def {
            
            self.transitioningDelegate = self
        }else {
            
            self.transitioningDelegate = nil
        }
    }
    
    func gestureRecognizerShouldBegin(_ gestureRecognizer: UIGestureRecognizer) -> Bool {
        
        if !cIsPopGestureRecognizer {
            
            return false
        }
        
        if children.count == 1 {
            
            return false
        }else {
            
            return true
        }
        
    }
    
    func gestureRecognizer(_ gestureRecognizer: UIGestureRecognizer, shouldBeRequiredToFailBy otherGestureRecognizer: UIGestureRecognizer) -> Bool {
        
        return true
    }
    
    func UMPCheck() {
        
    }
    
    override var preferredStatusBarStyle: UIStatusBarStyle {
        
        return barStatyl
    }
    
    override var prefersStatusBarHidden:Bool {
        
        return barHidden
    }
    
    func pushViewController(_ viewController: UIViewController, animated: Bool,pushAnimationType:PushAnimationType) {
        
        cPushAnimation = pushAnimationType
        
        super.pushViewController(viewController, animated: animated)
    }
    
    override var childForStatusBarStyle: UIViewController?{
        return topViewController
    }
    
    deinit {
        
        NotificationCenter.default.removeObserver(self)
    }
}

extension BaseNavViewController:UIViewControllerTransitioningDelegate {
    
    
    func animationController(forPresented presented: UIViewController, presenting: UIViewController, source: UIViewController) -> UIViewControllerAnimatedTransitioning? {
        
        return nil
        
    }
    
    func animationController(forDismissed dismissed: UIViewController) -> UIViewControllerAnimatedTransitioning? {
        return nil
    }
    
}

extension BaseNavViewController:UINavigationControllerDelegate {
    
    func navigationController(_ navigationController: UINavigationController,
                              animationControllerFor operation: UINavigationController.Operation,
                              from fromVC: UIViewController,
                              to toVC: UIViewController) -> UIViewControllerAnimatedTransitioning? {
        
        return nil
        
    }
    
}


