//
//  LockSreenBundle.swift
//  LockSreen
//
//  Created by edy on 2025/5/19.
//

import WidgetKit
import SwiftUI


let kind: String = "com.app.phonemanager.lockSreenWidget"
let kind1: String = "com.app.phonemanager.lockSreenWidgetBattery"

@main
struct LockSreenBundle: WidgetBundle {
    var body: some Widget {
        LockStorageSreen(type: lockSreenType(isStorage: true, kind: kind, displayName: "Storage", description: "Monitor your storage space"))
        LockBattSreen(type: lockSreenType(kind: kind1, displayName: "Battery", description: "Monitor your battery"))
//        LockStorageSreen(type: lockSreenType(kind: kind1, displayName: "Battery", description: "Monitor your battery"))
        LockBothSreen()
    }
}

struct LockStorageSreen: Widget {
    var type:lockSreenType = lockSreenType()
    var body: some WidgetConfiguration {
        StaticConfiguration(kind: kind, provider: LockSreenProvider()) { entry in
            if #available(iOS 17.0, *) {
                LockSreenEntryView(type: type, entry: entry)
                    .containerBackground(.fill.tertiary, for: .widget)
            } else {
                LockSreenEntryView(type: type, entry: entry)
                    .padding()
                    .background(Color.clear)
            }
        }
        .configurationDisplayName(type.displayName)
        .description(type.description)
        .supportedFamilies([.accessoryCircular,.accessoryRectangular])
    }
}

struct LockBattSreen: Widget {
    var type:lockSreenType = lockSreenType()
    var body: some WidgetConfiguration {
        StaticConfiguration(kind: kind1, provider: LockSreenProvider()) { entry in
            if #available(iOS 17.0, *) {
                LockSreenEntryView(type: type, entry: entry)
                    .containerBackground(.fill.tertiary, for: .widget)
            } else {
                LockSreenEntryView(type: type, entry: entry)
                    .padding()
                    .background(Color.clear)
            }
        }
        .configurationDisplayName(type.displayName)
        .description(type.description)
        .supportedFamilies([.accessoryCircular,.accessoryRectangular])
    }
}

struct LockBothSreen: Widget {
    let kind: String = "com.app.phonemanager.lockSreenWidgetBoth"
    var body: some WidgetConfiguration {
        StaticConfiguration(kind: kind, provider: LockSreenProvider()) { entry in
            if #available(iOS 17.0, *) {
                LockSreenBothView(entry: entry)
                    .containerBackground(.fill.tertiary, for: .widget)
            } else {
                LockSreenBothView(entry: entry)
                    .background(Color.clear)
            }
        }
        .configurationDisplayName("Both")
        .description("Monitor your battery and storage space")
        .supportedFamilies([.accessoryRectangular])
    }
}

